<#ibiztemplate>
TARGET=PSSYSTEM
</#ibiztemplate>

package ${pub.getPKGCodeName()}.util.rest;

import ${pub.getPKGCodeName()}.util.security.AuthenticationInfo;
import ${pub.getPKGCodeName()}.util.security.AuthenticationUser;
import ${pub.getPKGCodeName()}.util.security.AuthorizationLogin;
import ${pub.getPKGCodeName()}.util.security.AuthTokenUtil;
import ${pub.getPKGCodeName()}.util.service.AuthenticationUserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;

@RestController
@RequestMapping("/")
@ConditionalOnProperty( name = "ibiz.enablePermissionValid", havingValue = "false")
public class AuthenticationController
{

    @Value(${r'"${ibiz.jwt.header:Authorization}"'})
    private String tokenHeader;

    @Autowired
    private AuthTokenUtil jwtTokenUtil;

    @Autowired
    private AuthenticationUserService userDetailsService;

    @PostMapping(value = ${r'"${ibiz.auth.path:v7/login}"'})
    public ResponseEntity<AuthenticationInfo> login(@Validated @RequestBody AuthorizationLogin authorizationLogin){
        userDetailsService.resetByUsername(authorizationLogin.getUsername());
        final AuthenticationUser authuserdetail = userDetailsService.loadUserByLogin(authorizationLogin.getUsername(),authorizationLogin.getPassword());
        // 生成令牌
        final String token = jwtTokenUtil.generateToken(authuserdetail);
        // 返回 token
        return ResponseEntity.ok().body(new AuthenticationInfo(token,authuserdetail));
    }

    @GetMapping(value = ${r'"${ibiz.auth.account:ibizutil/account}"'})
    public ResponseEntity<AuthenticationUser> getUserInfo(){
        UserDetails userDetails = (UserDetails)  SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        AuthenticationUser authuserdetail=new AuthenticationUser();
        if(userDetails==null){
            throw new RuntimeException("未能获取用户信息");
        }
        else if(userDetails instanceof AuthenticationUser ) {
            authuserdetail= (AuthenticationUser)userDetails;
        }
        else {
            authuserdetail= userDetailsService.loadUserByUsername(userDetails.getUsername());
        }
            return ResponseEntity.ok().body(authuserdetail);
        }
}
